'''
Created on 24.10.2017

@author: PRORJM
'''

import math
from logging import root

class Network(object):
    '''
    classdocs
    '''

    def __init__(self):
        self.structure = []
        self.node_roles = []
        self.losses = 0
        self.investment = 0
        self.om = 0.005
        self.lifetime = 40
        self.designPressureLoss = 12
        
        # correction coefficient for calculation of heat losses
        self.corr_coeff = 1
        
        # network parameters (conductivities, pipe depth, ground heat transfer coefficient, pump elec. efficiency)
        self.net_params = {"lg": 1.0, "li": 0.027, "lc": 0.092, "ls": 50,"depth": 0.5, "alfa": 14.6, "pe": 0.7}
        
        # undisturbed ground temperature 
        self.Tg = 10 
        
        # feed and return temperatures
        self.Tf = 16 
        self.Tr = 8 
        
        # total emissions of materials and construction (kgCO2)
        self.emissions = 0


    def addPipe(self, pipe_id, start, end, dnsize, pipelen):
        self.structure.append([pipe_id, start, end, dnsize, pipelen])
        
    def readNetworkDefinition(self, system_data, dc_network, prod_con, dc_nodes):
        if len(self.structure) > 0:
            self.structure = []
            self.node_roles = []
            print("Erasing any previous network definitions...") 
            
        # 'GIS/La Marina/system_data.txt'
        f = open(system_data, 'r')
        try:
            data = []
            pipes = []
            while True:
                line = f.readline()
                if line.find('Pipeline:') > -1:
                    while True:
                        line = f.readline()
                        if line.find('Producers:') > -1:
                            break
                        else:
                            data.append(line.split())
                    break
                if line == '':
                    print('Error reading file!!')
                    break
            for i in range(0,len(data)):
                pipes.append([int(data[i][0].replace('L', '')), data[i][1], float(data[i][2])])
        except:
            print('Error reading file!!')
        finally:
            f.close()        
        
        f = open(dc_network, 'r')
        try:
            data = f.readlines()
            pipes2 = []
            for i in range(0,len(data)):
                data[i] = data[i].replace('\n', '').replace('L', '').replace('NOD', '').split('\t')
                pipes2.append([int(data[i][0]), int(data[i][1]), int(data[i][2])])
        except:
            print('Error reading file!!')
        finally:
            f.close()        
        
        #pipeinfo = []
        for i in range(0,len(pipes)):
            j = 0
            while (True):
                if j == len(pipes2):
                    print("Pipe not found, error!!")
                    break        
                if pipes2[j][0] == pipes[i][0]:
                    break
                else:
                    j = j + 1
            self.addPipe(pipes[i][0], pipes2[j][1], pipes2[j][2], pipes[i][1], pipes[i][2])
        
        # node roles
        f = open(prod_con, 'r')
        data = []
        try:
            content = f.readlines()
            for i in range(0,len(content)):
                content[i] = content[i].replace('\n', '').replace('NOD', '').split('\t')
                data.append([content[i][0], int(content[i][1])])
        except:
            print('Error reading file!!')
        finally:
            f.close()              

        f = open(dc_nodes, 'r')
        try:
            content = f.readlines()
            for i in range(0,len(content)):
                content[i] = content[i].replace('\n', '').replace('NOD', '').split('\t')
                nodenumber = int(content[i][0])
                for j in range(0,len(data)):
                    if data[j][1] == nodenumber:
                        if "P" in data[j][0]:
                            self.node_roles.append([nodenumber, 2]) 
                        elif "C" in data[j][0]:
                            self.node_roles.append([nodenumber, 1])                
                        break               
                if data[j][1] != nodenumber:
                    self.node_roles.append([nodenumber, 0])                
        except:
            print('Error reading file!!')
        finally:
            f.close()              
    
    def calculatePumpingElectricityConsumption(self, coolingDemand):
        # returns estimated pumping electricity consumption time series
        # designPressureLoss in (bar)
        
        cons = []
        relativePressureLoss = []  
        maxDemand = max(coolingDemand)

        # K * kJ/kgK
        dTcp = abs(self.Tf - self.Tr) * 4.180
        
        # average density kg/m3 for water
        roo = 988 

        # coefficients for estimating pd (% of design pressure loss) as a function of cooling load (% of maximum)
        a = 0.9
        b = 0.1
        
        for i in range(0, len(coolingDemand)):
            relativePressureLoss.append(a*((coolingDemand[i] / maxDemand)**2) + b * (coolingDemand[i] / maxDemand))
               
        for i in range(0, len(relativePressureLoss)):
            # volume flow (m3/s); V = (Q(kJ) / cpDT) / roo
            V = ( (coolingDemand[i]) / dTcp) / roo
            # pumping electricity consumption (kW or kWh/h); P = (V/3600 * dp(Pa)) / efficiency
            P = ( (V * (self.designPressureLoss * relativePressureLoss[i] * 100000)) / self.net_params['pe'] ) / 1000
            cons.append(P)
                
        return cons       
                
    def calculateLosses(self):
        # old default value, historical reasons!
        self.losses = 168.3668
        
        # loading pipe size specific parameters
        f = open("Data/pipedata.txt", 'r')
        try:
            data = f.readlines()
            pipedata = {}
            for i in range(1,len(data)):
                data[i] = data[i].replace('\n', '').split('\t')
                pipedata[data[i][0]] = [float(data[i][1]), float(data[i][2]), float(data[i][3]), float(data[i][4]), float(data[i][5]), float(data[i][6])]
        except:
            print('Error reading file!!')
        finally:
            f.close()    
        
        if len(self.structure) == 0:
            print('Network structure not defined, unable to calculate losses!')
            return
        
        # pipe specific heat losses here
        hls = []

        # effective laying depth
        Heff = self.net_params['depth'] + self.net_params['lg']/self.net_params['alfa']
        
        # calculating heat losses for each pipe in variable self.structure
        for i in range(0,len(self.structure)):
            
            # DH to DN; pure correction, maybe not needed in the future..
            params = pipedata[self.structure[i][3].replace("H", "N")]

            Dout = params[0]
            #d = params[1]
            Din = params[2]
            Dcase = params[3]
            Cd = params[4]
            dist = params[5]
            
            # pipe (steel) thermal resistance (minor)
            Rs = (1/2*math.pi*self.net_params['ls']) * math.log(Dout/Din)
            
            # insulation resistance (major)
            Ri = (1/2*math.pi*self.net_params['li']) * math.log((Dcase-Cd)/Dout)
            
            # casing resistance (minor)
            Rc = (1/2*math.pi*self.net_params['lc']) * math.log(Dcase/(Dcase-Cd))
            
            # total pipe resistance
            Rp = Rs + Ri + Rc
            
            # ground resistance =(1/(2*PI()*lg)) * LN((4*H)/Dc)
            Rg = (1/(2*math.pi*self.net_params['lg'])) * math.log((4*Heff)/Dcase)
                
            # resistance due pipe interaction =(1/(4*PI()*lg))*LN(1+((2*Heff)/dist)^2)
            Rh = (1/(4*math.pi*self.net_params['lg'])) * math.log(1+((2*Heff)/dist)**2)
            
            # =(Ri+Rj)/((Ri+Rj)^2-Rh^2)
            U1 = (Rp + Rg) / ( (Rp + Rg)**2 - Rh**2)
            
            # =Rh/((Ri+Rj)^2-Rh^2)
            U2 = Rh / ( (Rp+Rg)**2 - Rh**2)
        
            # heat loss itself =( U1*(Tf-Tsoil) - U2*(Tr-Tsoil) + U1*(Tr-Tsoil) - U2*(Tf-Tsoil) )*adjustment*pipe_len
            hls.append( ( U1*(self.Tf - self.Tg) - U2*(self.Tr - self.Tg) + U1*(self.Tr - self.Tg) - U2 * (self.Tf - self.Tg) ) * self.corr_coeff * self.structure[i][4] )
            #print(hls[i])
            
        # value in kW
        self.losses = sum(hls)/1000
        #print("total heat losses: "+str(self.losses))
        return self.losses
        
    def calculateInvestment(self):
       
        # loading pipe size specific parameters, here only costs
        f = open("Data/pipedata.txt", 'r')
        try:
            data = f.readlines()
            pipe_costs = {}
            for i in range(1,len(data)):
                data[i] = data[i].replace('\n', '').split('\t')
                pipe_costs[data[i][0]] = float(data[i][7])
        except:
            print('Error reading file!!')
        finally:
            f.close()    
        
        if len(self.structure) == 0:
            print('Network structure not defined, unable to calculate costs!')
            return
        
        # pipe specific heat losses here
        costs = []
        
        # calculating heat losses for each pipe in variable self.structure
        for i in range(0,len(self.structure)):
            
            # DH to DN correction, costs calculation.
            costs.append(pipe_costs[self.structure[i][3].replace("H", "N")] * self.structure[i][4])
            #print(costs[i])

        self.investment = sum(costs)            
        #print("total investment costs: "+str(self.investment))
        return self.investment
        
    def calculateEmissions(self):
        # loading pipe size specific parameters, here only emissions
        f = open("Data/pipedata.txt", 'r')
        try:
            data = f.readlines()
            spec_emissions = {}
            for i in range(1,len(data)):
                data[i] = data[i].replace('\n', '').split('\t')
                # production of pipes + construction of network
                spec_emissions[data[i][0]] = float(data[i][8]) + float(data[i][9])
        except:
            print('Error reading file!!')
        finally:
            f.close()    
        
        if len(self.structure) == 0:
            print('Network structure not defined, unable to calculate emissions!')
            return
        
        # pipe specific emissions here
        emissions = []
        
        # calculating emissions for each pipe in variable self.structure
        for i in range(0,len(self.structure)):
            
            # DH to DN correction, costs calculation.
            emissions.append(spec_emissions[self.structure[i][3].replace("H", "N")] * self.structure[i][4])
            #print(costs[i])

        self.emissions = sum(emissions) / self.lifetime            
        #print("total emissions: "+str(self.emissions))
        return self.emissions
                